/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.gui;

import com.leobeliik.convenientcurioscontainer.common.ConvenientContainer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;

public class ConvenientScreen
extends AbstractContainerScreen<ConvenientContainer> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("convenientcurioscontainer", "textures/gui/curios_container.png");
    private final int xSize = 176;
    private final int ySize = 186;
    private int currentScroll = 0;

    public ConvenientScreen(ConvenientContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97727_ = 186;
        this.f_97731_ = 92;
    }

    @ParametersAreNonnullByDefault
    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        if (mouseX > this.f_97735_ + 168 && mouseX < this.f_97735_ + 172 && mouseY > this.f_97736_ + 3 && mouseY < this.f_97736_ + 9) {
            this.m_169388_(ms, List.of(new TranslatableComponent("container_info").m_130940_(ChatFormatting.GRAY), new TranslatableComponent("container_RMB").m_130940_(ChatFormatting.GRAY), new TranslatableComponent("container_SRMB").m_130940_(ChatFormatting.GRAY)), Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double direction) {
        if (direction > 0.0 && ((ConvenientContainer)this.f_97732_).canScroll(1)) {
            ((ConvenientContainer)this.f_97732_).scroll(1);
            --this.currentScroll;
            return true;
        }
        if (direction < 0.0 && ((ConvenientContainer)this.f_97732_).canScroll(-1)) {
            ((ConvenientContainer)this.f_97732_).scroll(-1);
            ++this.currentScroll;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, direction);
    }

    @ParametersAreNonnullByDefault
    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        this.m_93228_(ms, this.getX(), this.getY(), 0, 0, 176, 186);
        this.renderCurios(ms);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseDragged, double xAmount, double yAmount) {
        return super.m_7979_(mouseX, mouseY, mouseDragged, xAmount, yAmount);
    }

    private void renderCurios(PoseStack ms) {
        if (((ConvenientContainer)this.f_97732_).curiosSize() > 0) {
            int barHeight = Math.min(((ConvenientContainer)this.f_97732_).curiosSize(), 9) * 18 + 12;
            this.m_93228_(ms, this.f_97735_ - 24, this.f_97736_ + 5, 186, 0, 25, 6);
            this.m_93228_(ms, this.f_97735_ - 24, this.f_97736_ + barHeight, 186, 4, 25, 7);
            if (((ConvenientContainer)this.f_97732_).hasCosmeticColumn()) {
                this.m_93228_(ms, this.f_97735_ - 43, this.f_97736_ + 5, 186, 0, 24, 6);
                this.m_93228_(ms, this.f_97735_ - 43, this.f_97736_ + barHeight, 186, 4, 24, 7);
            }
        }
        for (int i = ((ConvenientContainer)this.f_97732_).getSlots().size() - 1; i >= 72; --i) {
            Slot slot = ((ConvenientContainer)this.f_97732_).getSlots().get(i);
            if (slot instanceof CosmeticCurioSlot) {
                this.m_93228_(ms, this.f_97735_ + slot.f_40220_ - 6, this.f_97736_ + slot.f_40221_ - 2, 186, 11, 23, 19);
                continue;
            }
            if (!(slot instanceof CurioSlot)) continue;
            this.m_93228_(ms, this.f_97735_ + slot.f_40220_ - 6, this.f_97736_ + slot.f_40221_ - 2, 186, 11, 25, 19);
            if (!((ConvenientContainer)this.f_97732_).hasCosmeticColumn()) continue;
            this.m_93228_(ms, this.f_97735_ + slot.f_40220_ - 25, this.f_97736_ + slot.f_40221_ - 2, 186, 31, 23, 19);
        }
        if (((ConvenientContainer)this.f_97732_).curiosSize() > 9) {
            int barxPos = ((ConvenientContainer)this.f_97732_).hasCosmeticColumn() ? this.f_97735_ - 48 : this.f_97735_ - 29;
            this.m_93228_(ms, barxPos, this.f_97736_ + 5, 176, 0, 10, 176);
            int scrollXPos = ((ConvenientContainer)this.f_97732_).hasCosmeticColumn() ? this.f_97735_ - 44 : this.f_97735_ - 25;
            int scrollYPos = this.f_97736_ + (this.currentScroll == 0 ? 12 : Math.min(166 / (((ConvenientContainer)this.f_97732_).curiosSize() - 9) * this.currentScroll + 12, 166));
            this.m_93228_(ms, scrollXPos, scrollYPos, 186, 51, 5, 9);
        }
    }

    private int getX() {
        return (this.f_96543_ - 176) / 2;
    }

    private int getY() {
        return (this.f_96544_ - 186) / 2;
    }
}

